; -------------------------------------------------------------------------------------------------------------- ;
; Beach Head - In game variables
; -------------------------------------------------------------------------------------------------------------- ;
; Memory Layout
; -------------------------------------------------------------------------------------------------------------- ;
BH_MemScreenStatus        = $0400 ; 
BH_MemBasic               = $0800 ; 
BH_MemCodeLo              = $1e00 ; to $4003
BH_MemScreenSave          = $3c00 ; to 3fff
BH_MemCodeSprites         = $3f00 ; to $5e03 - will be copied to $e000-$fdff
BH_MemCharSet             = $4000 ; 
BH_MemScreenSetA          = $4800 ; TabVicMemControlSetA
BH_MemScreenSetB          = $4c00 ; TabVicMemControlSetB
BH_MemSprites             = $5000 ; 
BH_MemCodeHi              = $6580 ; to $c002
BH_Mem_unused_01          = $c003 ; to $cfff
BH_MemSpritesData         = $e000 ; 
BH_Mem_unused_02          = $fe00 ; to $feff
BH_MemKernal              = $ff00 ; to $ffff
; -------------------------------------------------------------------------------------------------------------- ;
; Screens
; -------------------------------------------------------------------------------------------------------------- ;
BH_Scrn_Gfx               = BH_MemScreenSetA        ; 
BH_Scrn_Gfx_A             = BH_MemScreenSetA        ; 
BH_Scrn_Gfx_B             = BH_MemScreenSetB        ; 
BH_Scrn_Gfx_Save          = BH_MemScreenSave        ; 
BH_Scrn_Gfx_RowLen          = $28                   ; 

BH_Scrn_GfxCharSets       = BH_MemCharSet           ; 

BH_Scrn_Status            = BH_MemScreenStatus      ; 
BH_Scrn_Status_OffStart     = $0300                 ; 
BH_Scrn_Status_OffTime      = $12                   ; 
BH_Scrn_Status_OffRow1      = $20                   ; 
BH_Scrn_Status_OffRow2      = BH_Scrn_Status_OffRow1 + BH_Scrn_Gfx_RowLen * $01 ; 
BH_Scrn_Status_OffRow3      = BH_Scrn_Status_OffRow1 + BH_Scrn_Gfx_RowLen * $02 ; 
BH_Scrn_Status_OffRow4      = BH_Scrn_Status_OffRow1 + BH_Scrn_Gfx_RowLen * $03 ; 
BH_Scrn_Status_OffRow5      = BH_Scrn_Status_OffRow1 + BH_Scrn_Gfx_RowLen * $04 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Sprite Pointers and Storage
; -------------------------------------------------------------------------------------------------------------- ;
BH_SpritePointers         = BH_Scrn_Gfx_A + $03f8   ; $4bf8
BH_SpritePointer00        = BH_SpritePointers + $00 ; $4bf8
BH_SpritePointer01        = BH_SpritePointers + $01 ; $4bf9
BH_SpritePointer02        = BH_SpritePointers + $02 ; $4bfa
BH_SpritePointer03        = BH_SpritePointers + $03 ; $4bfb
BH_SpritePointer04        = BH_SpritePointers + $04 ; $4bfc
BH_SpritePointer05        = BH_SpritePointers + $05 ; $4bfd
BH_SpritePointer06        = BH_SpritePointers + $06 ; $4bfe
BH_SpritePointer07        = BH_SpritePointers + $07 ; $4bff

BH_SpriteStore            = BH_MemSprites
BH_SpriteStore00          = BH_SpriteStore    + $00 * BH_SpriteStoreLen ; $5000 - $40
BH_SpriteStore01          = BH_SpriteStore    + $01 * BH_SpriteStoreLen ; $5040 - $41
BH_SpriteStore02          = BH_SpriteStore    + $02 * BH_SpriteStoreLen ; $5080 - $42
BH_SpriteStore03          = BH_SpriteStore    + $03 * BH_SpriteStoreLen ; $50c0 - $43
BH_SpriteStore04          = BH_SpriteStore    + $04 * BH_SpriteStoreLen ; $5100 - $44
BH_SpriteStore05          = BH_SpriteStore    + $05 * BH_SpriteStoreLen ; $5140 - $45
BH_SpriteStore06          = BH_SpriteStore    + $06 * BH_SpriteStoreLen ; $5180 - $46
BH_SpriteStore07          = BH_SpriteStore    + $07 * BH_SpriteStoreLen ; $51c0 - $47

BH_SpriteStore08          = BH_SpriteStore    + $08 * BH_SpriteStoreLen ; $5200 - $48
BH_SpriteStore09          = BH_SpriteStore    + $09 * BH_SpriteStoreLen ; $5240 - $49
BH_SpriteStore0a          = BH_SpriteStore    + $0a * BH_SpriteStoreLen ; $5280 - $4a
BH_SpriteStore0b          = BH_SpriteStore    + $0b * BH_SpriteStoreLen ; $52c0 - $4b
BH_SpriteStore0c          = BH_SpriteStore    + $0c * BH_SpriteStoreLen ; $5300 - $4c
BH_SpriteStore0d          = BH_SpriteStore    + $0d * BH_SpriteStoreLen ; $5340 - $4d
BH_SpriteStore0e          = BH_SpriteStore    + $0e * BH_SpriteStoreLen ; $5380 - $4e
BH_SpriteStore0f          = BH_SpriteStore    + $0f * BH_SpriteStoreLen ; $53c0 - $4f
; -------------------------------------------------------------------------------------------------------------- ;
; C64
; -------------------------------------------------------------------------------------------------------------- ;
C64_CBINV_HI              = $0317                   ; Vector to BRK Instruction Interrupt - hi
C64_CBINV_LO              = $0316                   ; Vector to BRK Instruction Interrupt - lo
C64_CINV_HI               = $0315                   ; Vector to IRQ Interrupt Routine - hi
C64_CINV_LO               = $0314                   ; Vector to IRQ Interrupt Routine - lo
; -------------------------------------------------------------------------------------------------------------- ;
